<?php


namespace Mtc\Shop\Events\Handlers;


use Mtc\Shop\Events\OrderPaidEvent;

/**
 * Class GoogleAnalyticsTrackHandler
 *
 * OrderPaid event handler that does the callback (server-server) Universal analytics tracking.
 *
 * @author Aleksey Lavrinenko
 *
 */
class GoogleAnalyticsTrackHandler
{
    /**
     * Payment types to use this type of tracking for
     *
     * @var array
     */
    static protected $paymentTypes = [
        \Order::PAYMENT_TYPE_PAYPAL,
        \Order::PAYMENT_TYPE_SAGEPAY_SERVER,
        \Order::PAYMENT_TYPE_WORLDPAY,
        \Order::PAYMENT_TYPE_BARCLAYCARD,
        \Order::PAYMENT_TYPE_BANK_OF_IRELAND,
    ];

    public function handle(OrderPaidEvent $event) {

        if (!GOOGLE_ANALYTICS_ECOM_ENABLED || GOOGLE_ANALYTICS_USERAGENT === '') {
            // tracking not enabled
            return;
        }

        if (!in_array($event->getPaymentType(), static::$paymentTypes)) {
            // we are not using this type of tracking for this type of payment
            return;
        }

        $order = $event->getOrder();
        require_once SITE_PATH . '/shop/checkout/includes/ga-universal/track.ua.ecom.server.php';
    }
}
