<?php

namespace Mtc\Shop\Events;

/**
 * Class ItemAdminTabnavEvent
 *
 * This is an event class. This event is called upon Admin > Item section
 * to allow adding additional menu items
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class ItemAdminTabnavEvent
{
    /**
     * @param \Item $item Current item
     */
    protected $item;

    /**
     * @param array $request $_REQUEST array
     */
    protected $request;


    /**
     * @return \Item
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * @return array
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \Item $item Item that is opened for editing
     * @param array $request $_REQUEST
     */
    public function __construct(\Item $item, array $request)
    {
        $this->item = $item;
        $this->request = $request;
    }
}