<?php

namespace Mtc\Shop\Events;

/**
 * Class OrderGetItemsEvent
 *
 * This is an event class. Used to fire and handle an "Order Get Items".
 * An instance of this class is passed to event handlers that subscribe to this event.
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 * @version 2016-05-30
 */
class OrderGetItemsEvent
{
    /**
     * @var \Order
     */
    protected $order;

    protected $order_item;

    /**
     * @return \Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return string
     */
    public function getItem()
    {
        return $this->order_item;
    }

    /**
     * @param \Order $order Order that is loaded
     * @param $order_item
     */
    public function __construct(\Order $order, $order_item)
    {
        $this->order = $order;
        $this->order_item = $order_item;
    }
}
