<?php
/**
 * Order Item Archive Object Eloquent model.
 * @version 03.07.2018
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Mtc\Shop\Item\BelongsToItem;
use Illuminate\Database\Eloquent\Model;

/**
 * Order Item Archive Object Eloquent model.
 * Manages order item archive
 *
 * @version 03.07.2018
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class ArchiveItem extends Model
{

    // Use trait that defines relationship to items
    use BelongsToItem;
    // Use trait that defines relationship to basket
    use BelongsToOrder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'order_archive_items';

    /**
     * @var array Guarded attributes. The rest are mass assignable
     */
    protected $guarded = [
        'id',
    ];

    public function order_item()
    {
        return $this->belongsTo(Item::class);
    }

}