<?php
/**
 * Order Coupon Object Eloquent model.
 * @version 31/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;

/**
 * Order Coupon Object Eloquent model.
 * Implements functionality for managing Shop Order Coupons
 *
 * @version 31/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Coupon extends Model
{
    // Use trait that defines relationship to order
    use BelongsToOrder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'order_coupon';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'order_id',
        'code',
        'freedelivery',
        'amountoff',
        'percentoff',
        'deduct',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

}