import Vue from 'vue';
import { config } from './config.js';
window.globalConfig = config;


// Import vue-wrapper for side effects (VueResource setup, directives, filters)
import './vue-wrapper.js';

// Set production mode when not in development
if (process.env.NODE_ENV === 'production') {
    Vue.config.productionTip = false;
}

import {EventBus, vueEventHub} from "./event-bus";
window.EventBus = EventBus;
window.vueEventHub = vueEventHub;




import agentAdminContainer from '@plugins/Agent/components/admin/container.vue';
Vue.component("agent-admin-container", agentAdminContainer);

window.vue_environment = new Vue({
    el: '#agent_vue_environment',
    delimiters: ['[%', '%]'],
    mounted() {
        $.holdReady(false);
    }
});
