<?php


$cats = ['' => '--Select Category--'];
$category_list = [];

if (!empty($p->pagedata['Category'])) {
    foreach ($p->pagedata['Category'] as $category) {

        $cat_name = str_replace('\'', '', $category['Category']['value']);
        $cat_name = strtolower(str_replace(' ', '-', $cat_name));
        $cats[$cat_name] = $category['Category']['value'];
        $category_list[$cat_name] = $category['Category']['value'];
    }
}

if(!empty($_REQUEST['news_cats'])) {
    header('Content-Type: application/json');
    echo json_encode($cats);
    die();
}

$news_container_page_id = $p->id; // IN NEWS PAGE

$news_filter = [];
$active_archive_from_date = null;
// regex validates date YYYY-MM-DD
$regex_date_validation = "/^[0-9]{4}-[0-9]{2}-[0-9]{2}$/";
if (!empty($_GET['filter_from']) && preg_match($regex_date_validation, $_GET['filter_from'])) {
    $news_filter[] = array("Publish Date", $_GET['filter_from']." 00:00:00", ">=", "datetime");
    $active_archive_from_date = $_GET['filter_from'];
}

if (!empty($_GET['filter_to']) && preg_match($regex_date_validation, $_GET['filter_to'])) {
    $news_filter[] = array("Publish Date", $_GET['filter_to']." 23:59:59", "<=", "datetime");
}
$current_tag = false;
if (!empty($_GET['tag'])) {
    $current_tag = $_GET['tag'];
    $news_filter[] = array("Tag", $_GET['tag'], "=", "varchar", "group_check");
}
if (!empty($_GET['category'])) {
    $news_filter[] = array("Category", $_GET['category'], "=", "varchar", "group_check");
}

// archive is the same lister but without filter
$lister = Listing::newInstance($news_container_page_id)->run();
$lister->getArchive([
    'base_url'          => $p->get_url(),
    'index'             => array('Publish Date', 'datetime'), // pass this option if you named the date field something other than "date"
    'display_count'     => true, // true by default, adds number of articles in a span tag within the title
    'month_format'      => 'F ', // You can pass standard php date formats in to here to have the archive show December 2015, January 2016 etc.
    'enable_year_links' => false // Set ups entire year as filterable link, false by default.
]);

$archive_html = CMSNav::generateMenu(
    $lister->archive,
    [
        'item_container_id_prefix'  => 'myArchiveMenu', // menu name so any ids are unique
        'first_container_class'     => 'accordionMenu js_accordionMenu', // class for first ul
        'active_page_id'            => $active_archive_from_date,
    ]
);
$twig->addGlobal('archive_html', $archive_html);

// Tags
$lister = Listing::newInstance($news_container_page_id)->run();
$lister->getTags([
    'base_url'          => $p->get_url(),
    'index'             => array('Tag', 'varchar'), // pass this option if you named the date field something other than "date"
    'display_count'     => false, // true by default, adds number of articles in a span tag within the title
    'display_active'    => $current_tag, // false by default, if tag is passed and matches title of an item found then 'active' becomes true
]);
$tags_html = CMSNav::generateMenu($lister->tags);
$twig->addGlobal('tags_html', $tags_html);
$twig->addGlobal('tags', $lister->tags);
$twig->addGlobal('active_tag', $current_tag);

// Set up listing
$articles = Listing::newInstance($news_container_page_id)
    ->setLimit(12)
    ->setOrder([array("Publish Date", "DESC", "datetime")])
    ->setCurrentPage((isset($_GET['page']) ? $_GET['page'] : null))
    ->setFilter($news_filter)
    ->run();

$articles->getListing();
$articles->getPagination($twig);

$twig_variables['news_list'] = $articles->list;
$twig_variables['categories'] = $category_list;
$twig_variables['request'] = $_REQUEST;
$twig_variables['pagination'] = $articles->pagination;

