# Figma-to-Laravel Slash Commands

This directory contains Claude Code slash commands for the Figma-to-Laravel workflow system.

## Available Commands

| Command | Purpose | Usage |
|---------|---------|-------|
| `/mtc-rebrand` | Rebrand design system from Figma | `/mtc-rebrand <full-page-figma-url>` |
| `/mtc-extract` | Extract **new** component to Twig + LESS | `/mtc-extract <component-figma-url>` |
| `/mtc-update` | Update **existing** component from Figma | `/mtc-update <figma-url> <component-name>` |
| `/mtc-cms-structure` | Generate CMS structure (optional) | `/mtc-cms-structure <component-name>` |

## Quick Start

### First Time Setup
```bash
# Rebrand design system (first time only)
/mtc-rebrand https://figma.com/design/your-design-file
```

### Component Development
```bash
# Extract NEW Figma component to Laravel (Twig + LESS)
/mtc-extract https://figma.com/design/your-file?node-id=26-215

# Update EXISTING component with new Figma design
/mtc-update https://figma.com/design/your-file?node-id=26-215 hero_banner

# Components viewable at:
# - New components: http://localhost/example-blocks
# - All components: http://localhost/component

# Generate CMS structure for the component (optional)
/mtc-cms-structure component-name
```

### Complete Workflow
```bash
# Simple 2-step process:

# 1. Extract to Twig + LESS (auto-adds to example-blocks)
/mtc-extract https://figma.com/design/your-file?node-id=26-215

# 2. (Optional) Generate CMS structure
/mtc-cms-structure component-name
```

## Command Files

Each `.md` file in this directory defines a slash command:

- `mtc-rebrand.md` - Design system rebrand workflow
- `mtc-extract.md` - Extract **new** Figma component (Twig + LESS)
- `mtc-update.md` - Update **existing** component from Figma
- `mtc-cms-structure.md` - CMS structure generation workflow

## How It Works

### Unified Extraction

The `/mtc-extract` command performs all extraction and integration in one step:

1. Verifies design system is rebranded
2. Parses Figma URL and extracts component name
3. Classifies component type (page_block, element, partial)
4. Creates Twig template with dummy data support
5. Creates LESS stylesheet using design tokens
6. Updates build system (adds LESS import)
7. Auto-adds component to example_blocks.twig
8. Runs build and validates with Playwright

### Output Locations

| Component Type | Twig Template | LESS Stylesheet |
|---------------|---------------|-----------------|
| Page Section | `includes/page_blocks/{name}.twig` | `css/blocks/{name}.less` |
| Element | `includes/elements/{name}.twig` | `css/elements/{name}.less` |
| Partial | `includes/partials/{name}.twig` | `css/elements/{name}.less` |

### Preview System

Components are auto-added to the example-blocks page:
```
http://localhost/example-blocks
```

## URL Requirements

### Design System Rebrand
**Use full page URLs (no node-id):**
```
✅ CORRECT: https://figma.com/design/abc123/MyDesign
❌ WRONG:   https://figma.com/design/abc123/MyDesign?node-id=26-215
```

### Component Extraction
**Use component URLs (with node-id):**
```
✅ CORRECT: https://figma.com/design/abc123/MyDesign?node-id=26-215
❌ WRONG:   https://figma.com/design/abc123/MyDesign
```

## Workflow Process

### 🎯 Recommended Flow

**For new components:**
1. **Design System Rebrand** (once): `/mtc-rebrand <full-page-url>`
2. **Component Extraction**: `/mtc-extract <component-url>`
3. **(Optional) CMS Structure**: `/mtc-cms-structure <component-name>`

**For existing components:**
1. **Browse components**: `http://localhost/component`
2. **Update from Figma**: `/mtc-update <figma-url> <component-name>`

## Error Handling

### Common Issues

**"Design system not rebranded"**
- Solution: Run `/mtc-rebrand <full-page-figma-url>` first

**"Invalid Figma URL"**
- Solution: Check URL format requirements above

**"Build system errors"**
- Solution: Check build logs and verify dependencies with `npm install`

**"asset() function detected"**
- Solution: Use `/sites/default/{{ variable }}` instead

**"<p> wrapping |raw content"**
- Solution: Use `<div>` wrapper instead of `<p>` for TinyMCE compatibility

## System Requirements

### Prerequisites
- Design system must be rebranded before component extraction
- Figma MCP server access for design token extraction
- Playwright MCP server access for visual validation
- Node.js and npm for build system

### Quality Standards
- 98%+ visual accuracy to Figma design
- Responsive across all breakpoints (375px - 2560px+)
- WCAG AA accessibility compliance
- 85%+ design system compliance score
- Zero console errors

## File Structure

### Generated Files
```
.frontend/
├── assets/                      # Extracted Figma assets
├── components/                  # Component documentation
└── figma-selections/            # Reference screenshots

sites/default/
├── templates/includes/
│   ├── page_blocks/             # Page section components
│   ├── elements/                # Reusable elements
│   └── partials/                # Small partials
├── css/
│   ├── blocks/                  # Page section stylesheets
│   └── elements/                # Element stylesheets
├── includes.less                # Auto-updated with imports
└── templates/pages/
    └── example_blocks.twig      # Auto-updated with component previews
```

## Reference Documentation

- **YAML Workflows**: `../.frontend/workflows-yaml/`
- **Detailed Processes**: `../.frontend/workflows/`

## Benefits

### Unified Workflow
- ✅ **Single command** extracts directly to Laravel (no HTML intermediate)
- ✅ **Auto-preview** at localhost/example-blocks
- ✅ **Auto-build integration** (LESS imports added automatically)
- ✅ **Playwright validation** against Figma reference

### Developer Experience
- Clear, discoverable commands
- Built-in argument validation and error messages
- Step-by-step guided workflows
- Live preview system for rapid iteration

---

**💡 New to the system?** Start with `/mtc-rebrand` to set up your design system, then use `/mtc-extract` to extract your first component.
