<!--
Sync Impact Report:
Version change: Template → v1.0.0 (Initial constitution)
Modified principles: All principles created from template
Added sections: Healthcare Compliance, Development Standards, Plugin Architecture
Removed sections: None (initial creation)
Templates requiring updates:
  ✅ Updated: plan-template.md (constitution check section)
  ✅ Updated: spec-template.md (healthcare requirements section)
  ✅ Updated: tasks-template.md (compliance validation tasks)
Follow-up TODOs: None - all placeholders resolved
-->

# Pharmacy Starter Constitution

## Core Principles

### I. Healthcare Compliance First (NON-NEGOTIABLE)
All features MUST consider patient safety and healthcare regulations. All patient data handling MUST comply with GDPR, MHRA, and pharmacy-specific regulations. Code handling sensitive medical information requires additional review gates and cannot be deployed without explicit compliance verification.

*Rationale: Healthcare systems require the highest standards of data protection and regulatory compliance. Patient safety supersedes development velocity.*

### II. Modular Plugin Architecture
System MUST maintain clear separation between core/, shop/, cms/, and plugins/ modules. New features SHOULD be implemented as plugins when possible. Plugin dependencies MUST be explicit with proper service provider registration. Cross-module communication MUST use defined interfaces, not direct class access.

*Rationale: The existing architecture supports pharmacy-specific extensions through plugins. This enables customization without compromising core stability.*

### III. Legacy-Compatible Evolution
Changes MUST maintain backward compatibility with existing functionality. Framework upgrades (like Webpack→Vite) MUST be incremental with migration documentation. Database changes MUST include migration scripts. Breaking changes require explicit justification and migration plans.

*Rationale: This is a production system serving real pharmacies. Stability and continuity are critical for business operations.*

### IV. Multi-Environment Consistency
All features MUST work across Docker, traditional server, and local development environments. Configuration MUST be environment-agnostic using .env files. Build processes MUST produce consistent outputs regardless of development environment.

*Rationale: The system supports multiple deployment models. Inconsistencies across environments lead to production issues and deployment failures.*

### V. Test-Driven Healthcare Features
New healthcare-related functionality MUST include PHPUnit tests before implementation. Integration tests MUST validate end-to-end patient workflows. Manual testing protocols MUST be documented for regulatory compliance. No healthcare feature ships without comprehensive test coverage.

*Rationale: Patient-facing features require rigorous validation. Testing is both a quality gate and regulatory requirement.*

## Healthcare Compliance Standards

All development MUST adhere to:
- **Patient Data Protection**: Encrypt sensitive data at rest and in transit
- **Audit Logging**: All patient data access MUST be logged with timestamps and user identification
- **Access Control**: Role-based permissions with pharmacy staff hierarchies
- **Data Retention**: Compliance with pharmacy record-keeping requirements
- **Regulatory Updates**: Code MUST accommodate changing healthcare regulations

## Development Standards

### PHP Backend Standards
- Follow PSR-12 coding standards for PHP code
- Use Laravel 11 conventions for models, services, and controllers
- Namespace organization: `Mtc\Core\`, `Mtc\Shop\`, `Mtc\Cms\` for core modules
- Plugin namespacing: `MtcPharmacy\{PluginName}\` for pharmacy-specific features

### Frontend Standards
- Vue.js 2 components in `sites/default/js/components/`
- Consistent prop validation and event emission patterns
- LESS preprocessing with shared variables and mixins
- Vite build system for asset compilation and hot reloading

### Database Standards
- Laravel migrations for all schema changes
- Model relationships using Eloquent conventions
- Seeders for test data and initial configuration
- Foreign key constraints for data integrity

## Plugin Architecture Guidelines

### Plugin Structure
- ServiceProvider for Laravel integration and route registration
- Classes/ directory for core plugin logic and business models
- Http/Controllers/ for admin and frontend API endpoints
- Console/Commands/ for CLI operations and scheduled tasks
- routes/web.php for plugin-specific routing

### Plugin Development Rules
- Plugins MUST be self-contained with minimal core dependencies
- Database tables MUST be prefixed with plugin identifier
- Configuration MUST be stored in plugin-specific config files
- Templates MUST be in plugin src/templates/ directory

## Governance

**Constitutional Authority**: This constitution supersedes all other development practices and coding standards. All pull requests MUST demonstrate compliance with core principles before merge approval.

**Amendment Process**: Constitutional changes require documentation of impact, stakeholder review, and migration plan for existing code. Changes affecting healthcare compliance require additional regulatory review.

**Compliance Verification**: Regular audits of codebase against constitutional principles. Healthcare features undergo additional compliance reviews before production deployment.

**Development Guidance**: See `readme.md` and `git_workflow_internal.md` for daily development workflows. Plugin development follows examples in `plugins/mtc_pharmacy_*` directories.

**Version**: 1.0.0 | **Ratified**: 2025-01-27 | **Last Amended**: 2025-01-27