<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Plugins\DeliveryCouriers\Classes\Courier;
use Mtc\Plugins\RyftPay\Classes\RyftPay;
use Mtc\Shop\DeliveryServicesOption;

class RyftCapturePaymentsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ryft:capture';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Bulk captures payments that have been authorised longer than 6 days';


    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(): int
    {
        if (!config('ryftpay.enabled') || !config('ryftpay.manual_capture')) {
            return 0;
        }
        RyftPay::bulkProcessReservedPayments();
        return 0;
    }
}
