<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AdminUserCreatedEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $userID;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(int $userID)
    {
        $this->userID = $userID;
    }

}
