<?php

namespace App\Events;

use Illuminate\Http\Request;
use Mtc\Shop\Assessment\Assessment;

/**
 * Class AssessmentCreatedEvent
 *
 * Event triggered when an assessment is created
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk
 * @version 08.11.2024
 */
class AssessmentCreatedEvent
{

    /**
     * @var Assessment $assessment
     */
    protected Assessment $assessment;

    /**
     * @var Request $request
     */
    protected Request $request;

    /**
     * @return Assessment
     */
    public function getAssessment(): Assessment
    {
        return $this->assessment;
    }

    /**
     * @return Request
     */
    public function getRequest(): Request
    {
        return $this->request;
    }

    /**
     * @param Assessment $assessment
     * @param Request $request
     */
    public function __construct(Assessment $assessment, Request $request)
    {
        $this->assessment = $assessment;
        $this->request = $request;
    }
}
