<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Shop\Item;

/**
 * Class IncompatibleMedicationController
 * @package App\Http\Controllers
 */
class IncompatibleMedicationController extends Controller
{
    /**
     * @param Request $request
     * @param Item $item
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Item $item)
    {
        $this->page_meta['title'] = 'Medication Interactions';

        // Butcher things for navigation
        $_REQUEST['id'] = $item->id;
        $item_model = $item;
        $item = new \Item($item_model->id);
        ob_start();
        require base_path('shop/admin/products/tabnav.php');
        $navigation = ob_get_clean();
        $copy_items = Item::query()
            ->active()
            ->orderBy('name')
            ->get()
            ->mapWithKeys(function ($item) {
                return [$item->id => $item->name];
            });
        return template('/admin/products/incompatible_medications.twig', [
            'item' => $item_model,
            'navigation' => $navigation,
            'page_meta' => $this->page_meta,
            'copy_items' => $copy_items,
            'all_medications' => json_encode(\Mtc\Shop\Medication::query()->pluck('name')->toArray()),
            'incompatible_medications' => $item_model->incompatible_medications,
        ]);
    }

    /**
     * @param Request $request
     * @param Item $item
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request, Item $item)
    {
        if (!empty($request->input('copy_item_id'))) {
            $copy_item = Item::query()->find($request->input('copy_item_id'));
            foreach ($copy_item->incompatible_medications as $medication) {
                unset($medication->item_id);
                $item->incompatible_medications()->create($medication->toArray());
            }
            session()->flash('success', 'Interactions copied successfully!');
            return back();
        }
        $this->validate($request, [
            'severity' => 'required',
            'medications' => 'required',
        ]);
        $medications = explode(',', $request->input('medications'));
        foreach ($medications as $medication) {
            $item->incompatible_medications()->create([
                'level' => $request->input('severity'),
                'message' => $request->input('message'),
                'medication' => $medication,
            ]);
        }
        session()->flash('success', 'Medications added');
        return back();
    }

    /**
     * @param Request $request
     * @param Item $item
     * @param $incompatible_medication_id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(Request $request, Item $item, $incompatible_medication_id)
    {
        Item\IncompatibleMedication::query()->where('id', '=', $incompatible_medication_id)->delete();
        session()->flash('success', 'Medication removed');
        return back();
    }
}
