<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\File;

class SitemapController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public static function index(Request $request)
    {
        $sitemapPath = public_path('sitemap.xml');

        if (!File::exists($sitemapPath)) {
            abort(404, 'Sitemap not found.');
        }

        return response()->file($sitemapPath, [
            'Content-Type' => 'application/xml',
        ]);
    }
}
