<?php

namespace App;

use Mtc\Shop\Item as ShopItem;
use Illuminate\Support\Str;


class ProductGroup
{
    private $product;

    const GROUP_A  = 'product_group_a';
    const GROUP_AP = 'product_group_a_peadiatric';
    const GROUP_D  = 'product_group_d';
    const GROUP_L  = 'product_group_l';


    public function __construct(ShopItem $product)
    {
        $this->product = $product;
    }


    public function getName()
    {
        $group = null;

        // Atovaquone and Proguanil 250mg/100mg Single Tablet (Malarone generic tablets)
        // Malarone Tablets 250/100mg Anti Malaria - Single Tablet
        // Maloff Protect Tablets
        if (Str::contains($this->product->name, [ 'Malarone', 'Maloff' ], true)) {
            $group = self::GROUP_A;
            // Atovaquone and Proguanil Paediatric 62.5mg/25mg Single Tablet (equivalent To Malarone Paediatric)
            // Malarone Paediatric Tablets 62.5/25mg Anti Malaria - Single Tablet
            if (Str::contains($this->product->name, [ 'Paediatric' ], true)) {
                $group = self::GROUP_AP;
            }

        // Doxycycline 100mg (Single Capsules)
        } elseif (Str::contains($this->product->name, [ 'Doxycycline' ], true)) {
                $group = self::GROUP_D;

        // Lariam (Mefloquine 250mg) Single Tablets
        } elseif (Str::contains($this->product->name, [ 'Lariam' ], true)) {
                $group = self::GROUP_L;
        }

        return $group;
    }
}
