<?php
/**
 * Script for checking if there' is already an exsiting pagedata structure file in the site directory
 * @author Rihards Siliņš
 * @copyright MTC media Ltd
 * @version 1 20/10/2016
 */
$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

use Mtc\Cms\Models\PageList;
use Mtc\Cms\Handlers\TemplateHandler;

if (empty($_GET['page_id']) || !is_numeric($_GET['page_id'])) {
    ContentManagerPanel::messageAndDie(
        "page_id missing from check pagedata structure for template structure file request.",
        "HTTP/1.0 400 Bad Request"
    );
}

if (empty($_GET['template']) || !TemplateHandler::validTemplateFilename($_GET['template'])) {
    ContentManagerPanel::messageAndDie(
        "valid template missing from store pagedata structure in the template request.",
        "HTTP/1.0 400 Bad Request"
    );
}
$page_template = $_GET['template'];

$page = ContentManagerPanel::loadPage($_GET['page_id'], false);
if (empty($page->id)) {
    ContentManagerPanel::messageAndDie(
        "The page which you wanted to add pagedata structure to was not found.",
        "HTTP/1.0 409 Conflict"
    );
}

$structure_filename = str_replace(".twig", ".json", $page_template);

// get location of structures dir
$twig_paths = $twig_loader->getPaths();
$structure_filename_full_path = $twig_paths[0] . '/structures/' . $structure_filename;

if (file_exists($structure_filename_full_path)) {
    exit("true");
}

exit("false");
