<?php
/**
 * Script for updating page list item data alt text
 * @author Rihards Siliņš
 * @copyright MTC media Ltd
 */
$cms_root_path = "../../../";
require_once $cms_root_path . "includes/compatibility_includer.php";

use Mtc\Cms\Models\PageListItemData as PageListItemData;

if (empty($_POST['page_list_item_data_id']) || !is_numeric($_POST['page_list_item_data_id'])) {
    header("HTTP/1.0 400 Bad Request");
    $error_message = "page_list_item_data_id missing from update alt text request.";
    ContentManagerPanel::addMessage($error_message);
    die($error_message);
}

if (!isset($_POST['alt_text'])) {
    header("HTTP/1.0 400 Bad Request");
    $error_message = "alt_text missing from update alt text request.";
    ContentManagerPanel::addMessage($error_message);
    die($error_message);
}

if (($page_list_item_data = PageListItemData::find($_POST['page_list_item_data_id'])) === null) {
    header("HTTP/1.0 409 Conflict");
    $error_message = "The pagedata you attempted to make updat alt text for was not found.";
    ContentManagerPanel::addMessage($error_message);
    die($error_message);
}

$page_list_item_data->data2 = $_POST['alt_text'];
$page_list_item_data->save();

exit(json_encode([
    "success" => true,
    "alt_text" => $page_list_item_data->data2
]));
