function listingInit(dom_scope) {
    if ( typeof dom_scope === 'undefined' || dom_scope === false || dom_scope === "" || dom_scope === 0 ) {
		dom_scope = '#listingContainer';
    }

    $(dom_scope).find('a.edit').on("click", function(event){
		cmsPreventDefault(event);
		anchorClickLoadPage($(this));
		return false;
    });

    $(dom_scope).find('a.delete').on("click", function(event){
		cmsPreventDefault(event);
		deleteListingItem($(this));
		return false;
    });

    $(dom_scope).find('ul.pagination > li > a').on("click", function(event){
		cmsPreventDefault(event);
		$(".listingPage").val($(this).attr("title"));
		getListingList();
		return false;
    });

	$(dom_scope).find('tbody.dragAndDropOrder').sortable({
		opacity: 0.6,
		handle: ".orderHandle",
		cursor: 'move',
		update: function() {
			ldrPending("ordering ...");
			var new_order = $(this).sortable("serialize");
			data = {
                'page_id': getPageId("live"),
            };
            $.ajax({
                type: 'get',
                cache: false,
                url: 'ajax/sort_listing_items.php?'+new_order,
                data: data,
            })
            .done(function() {
				getSiteTree();
                getListingList();
            })
            .fail(function(){
				ldrFailure();
                loadManageListingPanel();
            });
		}
	});

    $(dom_scope).find('.listingAdvFilterInput').on("change", function(event){
        cmsPreventDefault(event);
        $("#listing_page").val(1); // reset pagination
        getListingList();
        return false;
    });

	listingInitCustom(dom_scope);
}
