$(function(){

	if ( typeof phpDateFormatStringToJQueryFormat === undefined ) {
		function phpDateFormatStringToJQueryFormat(dateFormat) {
	        dateFormat = dateFormat.replace("d","dd");
	        dateFormat = dateFormat.replace("j","d");
	        dateFormat = dateFormat.replace("l","DD");
	        dateFormat = dateFormat.replace("z","o");
	        dateFormat = dateFormat.replace("F","MM");
	        dateFormat = dateFormat.replace("M","M");
	        dateFormat = dateFormat.replace("n","m");
	        dateFormat = dateFormat.replace("m","mm");
	        dateFormat = dateFormat.replace("Y","yy");
	        dateFormat = dateFormat.replace("y","y");

	        dateFormat = dateFormat.replace("H","HH");
	        dateFormat = dateFormat.replace("i","mm");
	        return dateFormat;
	    }
	}

    $.each($('form.moduleBuilder input.datetime'), function(index, el) {

        var format = $(el).attr("data-datetime-frontend-format");
        if ( format === undefined || format === "" ) {
            format = "d/m/Y H:i";
        }

        if ( $(el).val() === "" && format === "d/m/Y H:i" ) {
            var current_date = new Date();
            var string;
            current_date.setDate(current_date.getDate());

            string  = ('0' + current_date.getDate()).slice(-2) + '/';
            string += ('0' + (current_date.getMonth()+1)).slice(-2);
            string += '/' + current_date.getFullYear();
            string += ' ' + ('0' + current_date.getHours()).slice(-2) + ':';
            string += ('0' + current_date.getMinutes()).slice(-2);
 
            $(el).val(string);
        }

        var format_arr = format.split(" ");
        if ( format_arr[0] === undefined ) {
            format_arr[0] = "d/m/Y";
        }
        if ( format_arr[1] === undefined ) {
            format_arr[1] = "H:i";
        }

        $(el).datetimepicker({
            dateFormat: phpDateFormatStringToJQueryFormat(format_arr[0]),
            timeFormat: phpDateFormatStringToJQueryFormat(format_arr[1])
        });

    });

    
    $(".modelAutoSearch").autocomplete({
        source: "ajax/search_list.php?limit="+($(".modelAutoSearchLimit").val()),
        minLength: 0,
        response: function( event, ui ) {
            $(".listTBody").html("");
            if ( ui.content.length > 0 ) {
                for (var i = 0; i < ui.content.length; i++) {
                    $(".listTBody").append(ui.content[i].data);
                }
            } else {
                $(".listTBody").append("No Results Found");
            }
            return false;
        },
        open: function( event, ui ) {
            $(".ui-autocomplete").hide();
            console.log($(".modelAutoSearchLimit").val());
        }
    });

});