<?php

use Illuminate\Support\Collection;
use Mtc\Core\Admin\Menu;
use Mtc\Core\Permissions;

$adminuser = new AdminUser();
$menuID = $adminuser->menuID($_SERVER['SCRIPT_NAME']);
if (!empty($_SESSION['adminId'])
    && !AdminUser::can($menuID, $_SESSION['adminId'])
    && $menuID > 0
) {
    header("Location: /admin/index.php?access=none");
    exit();
}

if (!empty($_SESSION['adminId'])) {
    Permissions::initPermissions();

    $twig->addGlobal('admin_id', $_SESSION['adminId']);
    $twig->addGlobal('admin_user', $adminuser);

    $twigGlobals = $twig->getGlobals();
    if (empty($twigGlobals[Menu::GLOBAL_KEY])) {
        /** @var Collection $adminMenu */
        $adminMenu = Menu::getAdminMenu();
        $twig->addGlobal(Menu::GLOBAL_KEY, $adminMenu);
    }
} else {
    header("Location: /admin/login.php?redir=" . urlencode($_SERVER['REQUEST_URI']));
    exit();
}
