<?php

use Mtc\Core\Models\SeoPage;

/**
 * Seo pages class
 *
 * @author Lukas Giegerich | mtc.
 * @version 2014-01-20
 */
class SeoPages extends Seo
{

    /**
     * list of seo pages
     * @var array
     */
    public $seo_pages = array();

    function __construct() {
        parent::__construct();
    }

    /**
     * gets all seo pages from db
     */
    public function getPages(): array
    {
        return SeoPage::query()
            ->orderBy('path')
            ->get()
            ->keyBy('path')
            ->toArray();
    }

    /**
     * creates or updates seo page entry in db
     *
     * @param string $path
     * @param string $title
     * @param string $description
     */
    public function createOrUpdate($path, $title, $description)
    {
        SeoPage::query()
            ->updateOrCreate([
                'path' => $path
            ],[
                'title' => $title,
                'description' => $description,
            ]);
    }

    /**
     * gets seo page from db based on id
     *
     * @param int $id
     * @return array
     */
    public function getPage($id)
    {
        return SeoPage::query()
            ->where('id', $id)
            ->firstOrNew()
            ->toArray();
    }

    /**
     * deletes seo page from db
     *
     * @param int $id
     */
    public function deletePage($id)
    {
        SeoPage::query()
            ->where('id', $id)
            ->delete();
    }

}
