$(document).ready(function () {

    /*
     * force strict mode
     */

    'use strict';

    /*
     * Example Usage
     */

    // Default call
    $('.js_scrollLink').scrollPage();

    // Using a different animation and speed
    $('.js_scrollLinkEase').scrollPage({
        easing: 'easeOutBounce',
        speed: 2000
    });

    // Passing a different offset
    $('.js_scrollLinkOffset').scrollPage({
        scroll_offset: - 50
    });

    // Passing a different speed
    $('.js_scrollLinkSpeed').scrollPage({
        speed: 2000
    });

    // Changing the event handler (if not click)
    $('.js_scrollChange').scrollPage({
        event_handler: 'change'
    });

    // radio scroll
    $('.js_radioScroll').scrollPage({
        event_handler: 'change'
    });

    // Example of how to call complete function
    $('.js_completeCheck').scrollPage({}, function () {
        alert('im complete!');
    });

    // Complete function again with different options above it
    $('.js_completeCheckSlow').scrollPage({
        speed: 2000
    }, function () {
        alert('im finally complete!');
    });

}); // document ready