<?php
/**
 * Site map controller
 *
 * @author Andrew Morgan
 */

$page_meta = [
    'title' => 'Site map',
    'page_title' => 'Site map',
    'page_sub_title' => 'Every page on the site',
    'layout' => 'default.twig',
];

use Mtc\Shop\Brand;

$path = '../../';
require_once $path . 'core/includes/header.inc.php';

if (defined('CMS_ENABLED') && CMS_ENABLED === true) {

    $site_map_data['cms_tree'] = CMSNav::tree(
        0,
        PHP_INT_MAX,
        [
            'check_innav' => false // we want all the pages
        ]
    );

}

// Get the category tree
$site_map_data['category_tree'] = CategoryHelper::getCategoryTree();

// Get the brands tree if brands are enabled
if (defined('BRANDS_ENABLED') && BRANDS_ENABLED === true) {
    $site_map_data['brand_tree'] = Brand::getAllBrands();
}

$options = [
    'page_meta' => $page_meta,
    'site_map_data' => $site_map_data,
];

echo $twig->render('pages/sitemap.twig', $options);
