#!/bin/sh
# This script assumes it is run from the app project root

echo "----------------------------------------"
echo "Clearing app caches..."

php artisan config:cache
php artisan route:cache
php artisan view:cache
php artisan cache:clear
php artisan twig:clear

echo "----------------------------------------"
# Install PHP dependencies if composer.json is present
if [ -f composer.json ]; then
    echo "Installing PHP dependencies..."
    composer install --no-interaction --no-dev --prefer-dist --optimize-autoloader
else
    echo "composer.json not found in $(pwd) — skipping Composer install."
fi

echo "----------------------------------------"
echo "Running migrations..."
php artisan migrate --force

echo "----------------------------------------"
echo "Publishing media manager assets..."
php artisan vendor:publish --tag=media-manager

echo "----------------------------------------"
# Setup cron jobs
if [ -f crons.sh ]; then
    echo "Installing cron jobs..."
    sh crons.sh | crontab -
else
    echo "crons.sh not found — skipping cron install."
fi

echo "----------------------------------------"
echo "Compiling frontend assets..."
npm install && npm run build

echo "----------------------------------------"
echo "Deployment complete."
echo "----------------------------------------"
