<?php

namespace Mtc\Modules\BasketRecovery\Classes;

use Illuminate\Database\Eloquent\Model;
use Order;

/**
 * BasketRecoverySentEmails class
 *
 * This eloquent model provides the connection to any sent emails
 *
 * @author  Davis Lasis <davis.lasis@mtcmedia.co.uk>
 */
class BasketRecoverySentEmails extends Model
{
    // Columns permitted to be mass assigned
    protected $fillable = ['basket_id', 'recovery_id'];

    public $timestamps = true;


    /**
     * Order is marked as paid
     *
     * This is used alongside the hook in this modules loader.php
     * deletes all inputs from basket_recovery_sent_emails where it matches basket_id
     * 
     * @param  Order $order
     * @return null
     */
    public static function orderMarkPaid(order $order) 
    {
        self::where('basket_id', '=', $order->getBasketId())->delete();
    }

}
