<?php

namespace Mtc\Modules\BasketRecovery\Classes;

use Mtc\Core\Response;
use Mtc\Shop\Category;
use Mtc\Shop\Item;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
$collection = [];

if (filter_input(INPUT_GET, 'type') === BasketRecovery::SPECIFIC_PRODUCT) {

    $items = Item::query()
        ->where('hidden', 0)
        ->where('deleted', 0)
        ->orderBy('name')
        ->get()
    ;

    $response = [];
    foreach ($items as $item) {
        $response[] = [
            'id' => $item->id,
            'name' => $item->name,
        ];
    }

    Response::outputJson('ok', $response);
    exit;


} elseif (filter_input(INPUT_GET, 'type') === BasketRecovery::SPECIFIC_CATEGORY) {

    $collection = Category::query()
        ->select(['id', 'name'])
        ->orderBy('name')
        ->get()
    ;

    Response::outputJson('ok',$collection);
    exit;

}
