<?php
/**
 * Question Option list edit template
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Modules\FormBuilder\Classes;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
$page['title'] = 'Form Responses';

if (empty($_REQUEST['id'])) {
    header('Location: /modules/FormBuilder/admin/');
    exit;
}

$responses = FormResponse::where('form_id', $_REQUEST['id'])
    ->orderBy('date', 'DESC')
    ->get();
$form = Form::with('questions')
    ->where('id', $_REQUEST['id'])
    ->first();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<link rel="stylesheet" href="css/style.css" media="screen"/>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/modules/FormBuilder/admin/">Manage Forms</a> /</li>
    <li class="end">Form Responses</li>
</ul>

<h1>Form Responses</h1>
<h2><?= clean_page($form->name) ?></h2>

<?php
require 'tabnav.php';

if (count($responses) > 0) { ?>
    <table class="manage-items">
        <tbody class="tabular">
            <?php
            foreach ($responses as $response) {
                $response_values = $response->values()->get();
                if (!empty($response_values)) {
                    ?>
                    <tr>
                        <td>
                            <a class="toggleResultWrap">
                                <strong>Date: </strong>
                                <?= convert_date($response->date, 'd/m/Y H:i:s', 'Y-m-d H:i:s') ?> <br />
                            </a>
                            <div class="resultWrap">
                                <table>
                                    <?php
                                    foreach ($response_values as $value) {
                                        ?>
                                        <tr>
                                            <th>
                                                <?= clean_page($value->question->name) ?>
                                            </th>
                                            <td<?php if($value->correct === 1) { ?> style="background:green"<?php } ?>>
                                                <?= clean_page($value->value) ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                </table>
                            </div>
                        </td>
                    </tr>
                    <?php
                }
            }
            ?>
        </tbody>
    </table>
    <?php
} else {
    ?>
    <p>There are currently no forms added</p>
    <?php
}
require_once $path . 'core/admin/templates/adminfooter.html.php';
