<?php
/**
 * Question list edit template
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
?>
<div class="questionWrap clearfix">
    <div class="col side">
        <ul id="questionList">
            <li v-for="question in form.questions">
                <a class="questionListItem check_question"
                   v-on:click="changeQuestion(question.id)"
                   v-bind:class="{ 'active' : (active_question == question.id) }"
                   v-bind:id="'question_' + question.id">
                    [% question.name %]
                    <button type="submit"
                            v-on:click.prevent="removeQuestion(question.id)"
                            class="noBtn check_question removeQuestion"
                            value="Remove Question">
                        <i class="fa fa-trash"></i>
                    </button>

                    <i class="fa fa-exclamation-triangle error"
                       v-show="question.type == ''"
                       title="Type missing"></i>
                </a>
            </li>
        </ul>
        <button type="submit"
                v-on:click.prevent="addNewQuestion"
                class="btn check_question"
                id="addQuestion"
                name="add_question"
                value="Add Element">
            Add Question
        </button>
    </div>
    <div class="col main"
         id="questionContent"
         v-if="active_question > 0">
        <?php
        include 'templates/question.single.php';
        ?>
    </div>
</div>