<?php

namespace Mtc\Modules\Members\Classes;

use Illuminate\Support\Facades\Facade;
use Mtc\Modules\Members\Models\Member;

/**
 * Facade for the Authenticator class.
 *
 * @author Aleksey Lavrinenko
 * @contributor Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 12.11.2016.
 *
 * @method static login(Member $member, string $password = null)
 * @method static logout()
 * @method static isLoggedIn()
 * @method static getLoggedInMember()
 * @method static hashPassword($password)
 * @method static initiatePasswordReset(Member $member)
 */
class Auth extends Facade
{
    protected static function getFacadeAccessor() : string
    {
        return 'members_auth';
    }
}
