<?php
/**
 * Install Complimented Items
 *
 * The defaults are only set on the first load.
 * After this they are available to amend in site settings.
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 * @contributor Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Mtc\Core\Setting;
use Illuminate\Database\Capsule\Manager as Capsule;

$display_message = false;
if (empty($path)) {
    $path = '../../../../';
    require_once $path . "core/includes/header.inc.php";
    $display_message = true;
}

/**
 * Add Tables to database
 */
$schema = Capsule::connection()->getSchemaBuilder();

// Check if the table exists. If it doesn't, build it.
if ($schema->hasTable('items_complimented') === false) {
    // Build the table
    $schema->create('items_complimented', function ($table) {
        $table->increments('id');
        $table->integer('item_id')->index();
        $table->integer('complimented_item_id')->index();
        $table->smallInteger('order');
        $table->dateTime('created_at');
        $table->dateTime('updated_at');
    });
}

if (!defined('COMPLIMENTED_ITEMS')) {

    $data = [
        [
            'key' => 'COMPLIMENTED_ITEMS',
            'type' => 'bool',
            'value' => '1',
            'module' => 'Complimented Items',
            'description' => 'Set true to enable Complimented Items',
            'created_at' => new DateTime(),
        ],
        [
            'key' => 'COMPLIMENTED_MAX',
            'type' => 'int',
            'value' => '12',
            'module' => 'Complimented Items',
            'description' => 'Set the number of complimented items per product',
            'created_at' => new DateTime(),
        ],
        [
            'key' => 'COMPLIMENTED_SUPPLEMENT',
            'type' => 'bool',
            'value' => '1',
            'module' => 'Complimented Items',
            'description' => 'Set to true for adding similar items if not enough complimented items ',
            'created_at' => new DateTime(),
        ],
        [
            'key' => 'COMPLIMENTED_COLOR_SPECIFIC',
            'type' => 'bool',
            'value' => '0',
            'module' => 'Complimented Items',
            'description' => 'Complimented items to have the same colour as main item',
            'created_at' => new DateTime(),
        ],
        [
            'key' => 'COMPLIMENTED_MEMBER_SPECIFIC',
            'type' => 'bool',
            'value' => '0',
            'module' => 'Complimented Items',
            'description' => 'Set the number of complimented items per product',
            'created_at' => new DateTime(),
        ],
        [
            'key' => 'COMPLIMENTED_MEMBER_SPECIFIC_BRANDS_NUM',
            'type' => 'int',
            'value' => '0',
            'module' => 'Complimented Items',
            'description' => 'Set the number of complimented items per product',
            'created_at' => new DateTime(),
        ],
        [
            'key' => 'COMPLIMENTED_MEMBER_SPECIFIC_CAT_NUM',
            'type' => 'int',
            'value' => '0',
            'module' => 'Complimented Items',
            'description' => 'Set the number of complimented items per product',
            'created_at' => new DateTime(),
        ]
    ];

    Setting::Insert($data);
}

if ($display_message === true) {
    exit('Install successful');
}
