<?php

namespace Mtc\Plugins\DeliveryCouriers\Classes;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Event;
use Mtc\Shop\Events\OrderStatusChangedEvent;

if (!defined('DELIVERY_SERVICES_ENABLED')) {
    include __DIR__ . '/admin/install.php';
} elseif (DELIVERY_SERVICES_ENABLED === true) {

    // add instance for the Courier Oder Mapping facade
    // This can be overwritten if custom version is required
    App::bind(DeliveryCourierOrderMap::class, function ($app) {
        return new OrderMap();
    });

    Event::listen(OrderStatusChangedEvent::class, function (OrderStatusChangedEvent $event) {
        if ((int)$event->getStatus() === DELIVERY_COURIER_EXPORT_STATUS_ID) {
            Courier::sendOrder($event->getOrder());
        }
    });
}
