# Installation
Clone the repository into `~/public_html/plugins/FeefoReviews/`:

```bash
git clone https://YOUR_BITBUCKET_ACCOUNT@bitbucket.org/mtcmedia/core-plugins-feeforeviews.git ~/MY_FORK/plugins/FeefoReviews/
```

```bash
rm -rf ~/MY_FORK/plugins/FeefoReviews/.git
```

Update ``` FEEFO_REVIEWS_MERCHANT_IDENTIFIER ``` and ``` FEEFO_REVIEWS_API_KEY ``` from Feefo admin dashboard -> Settings -> Business Details.

Plugin settings are populated with default example Merchant Identifier and API Key.

# Settings
``` FEEFO_REVIEWS_ENABLED ``` - Turn on/off Feefo Reviews

``` FEEFO_REVIEWS_MERCHANT_IDENTIFIER ``` - This is used to identify your account in any sales data you send to Feefo and any integration methods you use to display reviews on your website.

``` FEEFO_REVIEWS_API_KEY ``` - This is used to authenticate your account for any secure integrations with Feefo such as the Enter Sales Remotely sale submission method and the secure version of the XML feed.

``` FEEFO_REVIEWS_BADGE_TEMPLATE ``` - Homepage Feefo badge template. Options can be found here https://support.feefo.com/support/solutions/articles/8000042108-feefo-badges and http://www.feefo.com/feefo/selectlogotemplate.jsp

``` FEEFO_REVIEWS_ITEM_REVIEWS ``` - This option turns on / off Feefo reviews tab for item full view.

``` FEEFO_REVIEWS_LATEST_REVIEWS ``` - This option turns on / off Feefo reviews list for homepage view.

``` FEEFO_REVIEWS_ENTER_SALES_REMOTELY ``` - This option turns on / off functionality that sends sales data to Feefo server after each successfull order.

``` FEEFO_REVIEWS_API_ENTER_SALES_REMOTELY_URL ``` - No need to change this unless Feefo changes it with newer version. https://support.feefo.com/support/solutions/articles/8000041823-entersaleremotely-api-introduction

``` FEEFO_REVIEWS_API_SUMMARY_URL ``` - No need to change this unless Feefo changes it with newer version.

``` FEEFO_REVIEWS_LOGS ``` - This option turns on / off all request and response log functionality, but system will write failed requests at all times even if turned off.


# Usage

Include Feefo badge on homepage footer.

``` {{ hooks_do_action('feefo_homepage_badge') }} ```

Include Feefo reviews summary schema itemprops meta tags on homepage. MUST be placed in homepage template only. If will be placed in all pages, Google will block star ratings. Admin area has Settings tab under Feefo Reviews section to fill in comapny data.

``` {{ hooks_do_action('feefo_homepage_summary_schema') }} ```

Include Feefo reviews for each item / product in full page view.

``` {{ hooks_do_action('feefo_item_reviews') }} ```

Include latest Feefo reviews.

``` {{ hooks_do_action('feefo_latest_reviews') }} ```

# Admin area
A link will automatically be added to the admin menu for you where you will be able to see all Feefo reviews and sales data logs.

#Feefo admin dashboard main account:

www.feefo.com

Username: daniel.mccabe@mtcmedia.co.uk

Password: Golfingsalmon1793"

# Author

Davis Lasis

davis.lasis@mtcmedia.co.uk
