<?php
namespace Mtc\Migrations;

use Mtc\Core\Models\MigrationTemplate;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Schema\Builder as SchemaBuilder;


class AddSeoSchemaTable implements MigrationTemplate
{

    public function up(SchemaBuilder $schema)
    {
        if (!$schema->hasTable('items_seo_schema')) {
            $schema->create('items_seo_schema', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('item_id')->index();
                $table->string('item_type')->index();
                $table->integer('parent_id')->index();
                $table->integer('lft')->index();
                $table->integer('rgt')->index();
                $table->integer('depth');
                $table->string('field')->index();
                $table->string('value');
                $table->timestamps();
            });
        }

        return true;
    }

    public function getDescription()
    {
        return 'Add Seo Schema tables for item schema';
    }

    public function down(SchemaBuilder $schema)
    {

    }

    public function getPrettyName()
    {
        return 'Add Seo Schema table';
    }
}
