<?php
namespace Mtc\Plugins\SeoSchema\Classes;

use \Item;
use Mtc\Plugins\ItemFAQ\Classes\ItemFAQ;
use Mtc\Shop\Category;
use Illuminate\Support\Facades\Event;
use MtcPharmacy\Multisite\Classes\MultisiteManager;
use Twig\Environment;


$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
$page_meta['title'] = 'Item Seo Schema';
$messages = [];

$id = (int)filter_input(INPUT_GET, 'id');

if (empty($id)) {
    header('Location: /shop/admin/products/manage.products.php');
    exit();
}

$is_category = filter_input(INPUT_GET, 'type') === 'category';

$requested_item_id = (int)$_REQUEST['id'];

$mm = null;
if ($is_category) {
} else {
    $requested_item = \Mtc\Shop\Item::find($_REQUEST['id']);
    if ($requested_item) {
        $mm = new MultisiteManager($requested_item);
        $mm->ensureTheCorrectAdminPageLoaded();
    }
}

ob_start();
$is_category = filter_input(INPUT_GET, 'type') === 'category';
if ($is_category) {
    $faq_object = (new Category())->find($id);
    require_once $path . 'shop/admin/categories/tabnav.php';
} else {
    $faq_object = new Item($id);
    require_once $path . 'shop/admin/products/tabnav.php';
}
$tabnav = ob_get_clean();

if (filter_input(INPUT_GET, 'action') === 'remove') {
    ItemFAQ::query()
        ->where(($is_category ? 'category_id' : 'item_id'), $faq_object->id)
        ->where('id', filter_input(INPUT_GET, 'remove_id'))
        ->delete();
    // Update the cache for item
    ItemFAQ::updateCache($faq_object);

    // store message and redirect to get page
    $_SESSION['message'] = [
        'type' => 'success',
        'content' => 'FAQ item removed'
    ];
    header('Location: ' . \Util::remove_query_arg(['action', 'remove_id']));
    exit;
}

if (filter_input(INPUT_POST, 'action') === 'update') {

    foreach ($_POST['question'] as $id => $value) {
        ItemFAQ::query()
            ->where(($is_category ? 'category_id' : 'item_id'), $faq_object->id)
            ->where('id', $id)
            ->update([
                'question' => $value,
                'answer' => $_POST['answer'][$id]
            ]);

    }
    // Update the cache for item
    ItemFAQ::updateCache($faq_object);

    // store message and redirect to get page
    $_SESSION['message'] = [
        'type' => 'success',
        'content' => 'FAQ values are updated'
    ];
    header('Location: ' . \Util::remove_query_arg(['action']));
    exit;

}

// When we're switching between modes of where the faq information is taken from
if (filter_input(INPUT_GET, 'action') === 'change_faq_mode') {
    // Load the item and update its FAQ setting
    $item = \Mtc\Shop\Item::query()->find($faq_object->id);
    $item->use_category_faq = filter_input(INPUT_GET, 'use_category_faq');
    $item->save();

    // Update the cache for item
    ItemFAQ::updateCache($faq_object);

    // store message and redirect to get page
    $_SESSION['message'] = [
        'type' => 'success',
        'content' => 'FAQ item source was updated'
    ];
    header('Location: ' . \Util::remove_query_arg(['action', 'use_category_faq']));
    exit;
}

if (filter_input(INPUT_POST, 'action') === 'add_new') {
    ItemFAQ::query()
        ->create([
            'item_id' => $is_category ? 0 : $faq_object->id,
            'category_id' => $is_category ? $faq_object->id : 0,
            'question' => filter_input(INPUT_POST, 'new_question'),
            'answer' => filter_input(INPUT_POST, 'new_answer')
        ]);

    // Update the cache for item
    ItemFAQ::updateCache($faq_object);

    // store message and redirect to get page
    $_SESSION['message'] = [
        'type' => 'success',
        'content' => 'FAQ info updated'
    ];
    header('Location: ' . \Util::remove_query_arg(['action', 'use_category_faq']));
    exit;
}

if (!empty($_SESSION['message'])) {
    $messages[] = $_SESSION['message'];
}
/** @var Environment $twig */
$twig->display('ItemFAQ/admin/index.twig', [
    'page_meta' => $page_meta,
    'id' => $faq_object->id,
    'item' => $faq_object,
    'type' => $is_category ? 'category' : 'item',
    'entries' => ItemFAQ::query()->where(($is_category ? 'category_id' : 'item_id'), $faq_object->id)->orderBy('order')->get(),
    'tabnav' => $tabnav,
    'messages' => $messages,
    'faq_preview' => '',
    'multisite_toggle_html' => ($mm ? $mm->getToggleHtml() : ''),
]);
unset($_SESSION['message']);
