<?php
namespace Mtc\Plugins\Judopay\Classes;

use Illuminate\Database\Eloquent\Model;

class JudopayPayment extends Model
{
    protected $table = 'judopay_payments';

    public $timestamps = true;

    protected $fillable = [
        'order_id',
        'receipt_id',
        'trx_ref',
        'amount',
        'currency',
        'type',
        'acquirer_transaction_id',
        'method',
    ];

    public function getRefAttribute()
    {
        return config('site.tnx_prefix') . $this->order_id;
    }
}
