<?php

namespace Mtc\Modules\MembersMessaging\Classes;


use Mtc\Core\Admin\Role;
use Mtc\Plugins\MembersMessaging\Classes\Templates;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'act',
    'startnumber',
    'id',
]);

$page_meta['title'] = 'Edit template';

$action = filter_var($_REQUEST['act'], FILTER_SANITIZE_STRING);
$id = filter_var($_REQUEST['id'], FILTER_SANITIZE_NUMBER_INT);

if($action === 'save') {
    $name = $_REQUEST['name'];
    $text = preg_replace("/\r\n|\r|\n/",'', $_REQUEST['text']);

    if($id > 0) {
        $template = Templates::find($id);
    } else {
        $template = new Templates();
    }

    $template->fill($_REQUEST);
    $template->text = $text;


    $template->save();

    header('Location: /plugins/MembersMessaging/admin/edit_templates.php');
    exit;
}


if (is_numeric($_REQUEST['startnumber'])) {
    $startnumber = $_REQUEST['startnumber'];
} else {
    $startnumber = 0;
}


require_once $path . 'core/admin/templates/adminheader.html.php';
?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Edit template</li>
    </ul>

    <h1>Edit template</h1>

    <?php
    require 'tabnav.php';
    $template = Templates::find($id);

    ?>

<form action="edit_template.php?act=save" method="post">
    <fieldset class="row">
        <div class="row">
            <label for="category">Category:</label>
            <select name="category" id="category">
                <?php
                foreach (Templates::$categories as $category => $label) {
                    ?>
                    <option value="<?= $category ?>" <?= ($template && $template->category === $category) ? 'selected': '' ?>>
                        <?= clean_page($label) ?>
                    </option>
                    <?php
                }
                ?>
            </select>
        </div>
        <div class="row">
            <label for="role">Template for:</label>
            <select name="role" id="role">
                <option value="0"<?php if ($template && $template->role == 0){ ?> selected="selected"<?php } ?>>Everyone</option>
                <?php
                    $roles = Role::all();
                    foreach($roles as $role) {
                ?>
                <option value="<?= $role->id; ?>"<?php if($template && $role->id == $template->role){ ?> selected="selected"<?php } ?>><?= $role->name; ?></option>
                <?php } ?>
            </select>
        </div>
        <div class="row">
            <label for="name">Name:</label>
            <input type="text" value="<?= ($template->name ?? '') ?>" id="name" name="name" />
        </div>
        <div class="row">
            <label for="text">Text:</label>
            <textarea class="tinymce" name="text" id="text"><?= ($template->text ?? '') ?></textarea>
        </div>
        <div class="row">
            <?php if($id > 0) { ?>
                <input type="hidden" value="<?= $id; ?>" name="id" />
            <?php } ?>
            <input type="submit" value="Save" />
        </div>
    </fieldset>
</form>
