<?php

use MTC\Core\Setting;

$data = [

    /* SANDBOX */

    [
        'key' => 'REALEX_ENABLED',
        'type' => 'bool',
        'value' => true,
        'module' => 'REALEX',
        'description' => 'Enable / Disable Payment Gateway',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'REALEX_MERCHANT_ID',
        'type' => 'string',
        'value' => '',
        'module' => 'REALEX',
        'description' => 'Merchant ID',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'REALEX_APP_SECRET',
        'type' => 'string',
        'value' => '',
        'module' => 'REALEX',
        'description' => 'Shared Secret used by the API',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'REALEX_ENDPOINT',
        'type' => 'string',
        'value' => 'https://pay.realexpayments.com/pay',
        'module' => 'REALEX',
        'description' => 'API endpoint',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'REALEX_CAPTURE_ENDPOINT',
        'type' => 'string',
        'value' => 'https://api.sandbox.realexpayments.com/epage-remote.cgi',
        'module' => 'REALEX',
        'description' => 'API Delayed Capture endpoint',
        'created_at' => new \DateTime(),
    ],


    /* LIVE */

    [
        'key' => 'REALEX_TEST_MERCHANT_ID',
        'type' => 'string',
        'value' => '',
        'module' => 'REALEX',
        'description' => 'Test Merchant ID',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'REALEX_TEST_APP_SECRET',
        'type' => 'string',
        'value' => '',
        'module' => 'REALEX',
        'description' => 'Test Shared Secret used by the API',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'REALEX_TEST_ENDPOINT',
        'type' => 'string',
        'value' => 'https://pay.sandbox.realexpayments.com/pay',
        'module' => 'REALEX',
        'description' => 'API endpoint',
        'created_at' => new \DateTime(),
    ],
    [
        'key' => 'REALEX_TEST_CAPTURE_ENDPOINT',
        'type' => 'string',
        'value' => 'https://api.sandbox.realexpayments.com/epage-remote.cgi',
        'module' => 'REALEX',
        'description' => 'API Delayed Capture endpoint',
        'created_at' => new \DateTime(),
    ],

];

foreach ($data as $key => $values) {
    if (defined($values['key'])) {
        unset($data[$key]);
    }
}

Setting::insert($data);
