<?php

use Mtc\Plugins\RyftPay\Classes\RyftPayment;

$path = '../../../';

require_once $path . 'core/includes/header.inc.php';

if (empty($_SESSION['ryft_order_id'])) {
    header('Location: ' . SITE_URL . '/shop');
    die;
}

$order = new Order($_SESSION['ryft_order_id']);

/** @var RyftPayment $payment */
$payment = RyftPayment::query()
    ->where('order_id', $_SESSION['ryft_order_id'])
    ->first();

if (empty($payment)) {
    header('Location: ' . SITE_URL . '/shop');
    die;
}

if ($payment->status === RyftPayment::STATUS_FAILED) {
    // Payment indeed failed
    $page_meta = [
        'title' => 'Your order has not been processed | ' . config('app.name'),
        'page_title' => 'Order issue',
    ];

    echo $twig->render('shop/checkout/order_failed.twig', [
        'page_html' => '',
        'page_meta' => $page_meta,
        'subtitle' => 'Your order failed to process.',
    ]);
    die;
}

$page_meta = [
    'title' => 'Your order is now complete | ' . config('app.name'),
    'page_title' => 'Order Complete',
    'page_sub_title' => 'Thank you for shopping online with ' . config('app.name'),
];

$tracking_code[] = $twig->render('analytics_js.twig', [
    'order' => $order,
    'settings' => $settings,
]);

echo $twig->render('shop/checkout/order_complete.twig', [
    'page_html' => '',
    'page_meta' => $page_meta,
    'basket_object' => $order,
    'tracking_code' => $tracking_code,
    'payment_method' => $_GET['method'] ?? '',
]);

unset($_SESSION['ryft_order_id']);
unset($_SESSION['basket_id']);
die;
