## Installation ##

1. Copy config file from plugin's `/config` into project config folder
2. Copy migration file from plugin's `/database/migrations` into project migrations folder
3. Run the migrations: `php artisan migrate`
4. Add the following rule to project's `.htaccess` file: `RewriteRule ^shop/checkout/ryftpay/?(.*) /plugins/RyftPay/checkout/$1.php [QSA,L]`
5. In the `shop/checkout/basket_overview.php` file add a line `RyftPay::form($newbasket);` where you pass the basket instance which contains `order_id`
6. In the `shop/templates/shop/basket/overview.twig` add a line `{{ ryftpay_assets() }}` in the head block
7. In the `sites/default/js/app.js` add line `require("../../../plugins/RyftPay/js/ryftpay.js");`
8. Get the public and secret keys from the Ryft developer account and place these in the `.env` file. 
9. Create a webhook and specify the webhook location in the Ryft developer account. The webhook URL is `SITE_URL/shop/checkout/ryftpay/webhook`
10. Enable the payment gateway in the `.env` file
11. Run `npm run dev` to compile the new assets

## Usage ##

Once set up and enabled, the payment gateway will be displayed in the basket overview page as an iFrame block.

When in test mode (from config file) the payment gateway will show test card details that can be used to test the payment

The integration listens to the events on the webhook and subsequently updates payment status and marks order paid if the payment has been successful  

The integration uses Ryft SDK which displays the iFrame and handles the payment on the basket overview page. Once it returns a success result, the customer is redirected to the order complete page.

On the order complete page the customer will see the success message, unless the payment status is `failed`. The order will be marked paid and a confirmation email will be sent once the webhook receives payment success event. That should be instant or take no longer than a minute.

## Manual capture ##

Manual capture can be used to authorise funds on customers cards and capture them only once the shipment has been made. This way, if the payment is cancelled, then no card processing fees are applied.

To use this, in the config file enable `manual_capture`.

When an order is placed, the payment is authorised.

Once the order is shipped, the payment is captured.

IMPORTANT: Please make sure you create an hourly process that executes `RyftPay::bulkProcessReservedPayments()` function. This function captures any payments that are older than 6 days and have not yet been captured (the order is not yet shipped). If this function is not executed then 7 days after the order is placed, the payment will be cancelled.

### Refunds ###

When creating a refund on the order, it will check the payment status.
- If the payment is captured, then it will send a refund request to Ryft API
- If the payment is authorised, but not captured:
  - When doing a full refund, it will simply cancel the payment
  - When doing a partial refund, it will do a partial charge (payment amount - refund amount) and mark the payment as captured. On the Ryft platform the payment will remain authorised and the remainder will be voided 7 days after order has been placed

## Manual capture ##

Manual capture can be used to authorise funds on customers cards and capture them only once the shipment has been made. This way, if the payment is cancelled, then no card processing fees are applied.

To use this, in the config file enable `manual_capture`.

When an order is placed, the payment is authorised.

Once the order is shipped, the payment is captured.

IMPORTANT: Please make sure you create an hourly process that executes `RyftPay::bulkProcessReservedPayments()` function. This function captures any payments that are older than 6 days and have not yet been captured (the order is not yet shipped). If this function is not executed then 7 days after the order is placed, the payment will be cancelled.

### Refunds ###

When creating a refund on the order, it will check the payment status.
- If the payment is captured, then it will send a refund request to Ryft API
- If the payment is authorised, but not captured:
  - When doing a full refund, it will simply cancel the payment
  - When doing a partial refund, it will do a partial charge (payment amount - refund amount) and mark the payment as captured. On the Ryft platform the payment will remain authorised and the remainder will be voided 7 days after order has been placed