<?php
/**
 * Static Block Image Paths are defined here
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\StaticBlocks\Classes;
use Util;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
$page['title'] = 'Manage Image Block Sizes';
$errors = [];
$regexr = "/[a-z0-9_]+/";

if (!empty($_REQUEST['action']) && $_REQUEST['action'] == 'delete'
    && !empty($_REQUEST['delete_id']) && $_REQUEST['delete_id'] > 0) {
    StaticBlockSizes::destroy($_REQUEST['delete_id']);
    $message = 'Path removed';
}

if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'add') {
    if (empty($_REQUEST['name'])) {
        $errors['name'] = 'Size name is required';
    } else {
        if (!(preg_match($regexr, $_REQUEST['name'], $matches)
            && $matches[0] == $_REQUEST['name'])) {
            $errors['name'] = 'Given size name is not valid';
        }
    }
    if (empty($_REQUEST['width']) || (int) $_REQUEST['width'] == 0) {
        $errors['width'] = 'Width must be a numeric value larger than 0';
    }
    if (empty($_REQUEST['height']) || (int) $_REQUEST['height'] == 0) {
        $errors['height'] = 'Height must be a numeric value larger than 0';
    }
    if (empty($errors)) {
        $size = new StaticBlockSizes();
        $size->name = trim(strtolower(Util::remove_accents($_REQUEST['name'])));
        $size->width = intval($_REQUEST['width']);
        $size->height = intval($_REQUEST['height']);
        if (isset($_REQUEST['crop'])) {
            $size->crop = 1;
        }
        if (isset($_REQUEST['forced'])) {
            $size->forced = 1;
        }
        $size->save();
        $message = 'Path created';
    }
}

if ($adminuser->user['id'] == MTCADMIN_USERID) {
    $is_admin = true;
} else {
    $is_admin = false;
}
if (!$is_admin) {
    header('Location: /plugins/StaticBlocks/admin/');
    exit;
}
require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Manage blocks</li>
</ul>

<h1>Manage Image Block Sizes</h1>

<?php
require 'tabnav.php';

if (!empty($message) && isset($_REQUEST['action'])) {
    echo showmsg($message, "success", $path);
}

$sizes = StaticBlockSizes::all();
?>
<form action="<?= $_SERVER['PHP_SELF']; ?>" method="post" class="style">
    <fieldset class="show">
        <h1 class="show">Add New Size</h1>
        <?php
        if (sizeof($errors)>0) {
            showerrors($errors);
        }
        ?>
        <div class="row">
            <?php
            $value = '';
            if (!empty($_REQUEST['name'])) {
                $value = $_REQUEST['name'];
            }
            ?>
            <label for="name">Size Name</label>
            <input type="text" name="name" id="name"
                   placeholder="Allowed format <?= trim($regexr, '/') ?>"
                   value="<?= clean_page($value) ?>" />
        </div>
        <div class="row">
            <?php
            $value = '';
            if (!empty($_REQUEST['width'])) {
                $value = $_REQUEST['width'];
            }
            ?>
            <label for="width">Width</label>
            <input type="text" name="width" id="width"
                   value="<?= clean_page($value) ?>" />
        </div>
        <div class="row">
            <?php
            $value = '';
            if (!empty($_REQUEST['height'])) {
                $value = $_REQUEST['height'];
            }
            ?>
            <label for="height">Height</label>
            <input type="text" name="height" id="height"
                   value="<?= clean_page($value) ?>" />
        </div>
        <div class="row">
            <label for="crop">Crop</label>
            <input type="checkbox" name="crop" id="crop" value="1" checked="checked" />
        </div>
        <div class="row">
            <label for="forced">Forced</label>
            <input type="checkbox" name="forced" id="forced" value="1" />
        </div>
        <div class="row">
            <input type="hidden" name="action" value="add" />
            <input type="submit" name="submit" value="Add" />
        </div>
    </fieldset>
</form>
<form action="<?= $_SERVER['PHP_SELF']; ?>" method="post">
    <?php
    if (count($sizes) > 0) {
        ?>
        <table class="manage-items">
            <tr>
                <th>Name</th>
                <th>Width</th>
                <th>Height</th>
                <th>Crop</th>
                <th>Forced</th>
                <th class="center">Delete</th>
            </tr>
            <tbody class="tabular">

                <?php
                $donotdelete = [
                    STATIC_BLOCKS_ORIGINAL_SIZE_ID,
                    STATIC_BLOCKS_THUMB_SIZE_ID,
                ];
                foreach ($sizes as $size) {
                    $flag = !$flag;
                    ?>
                    <tr>
                        <td><?= clean_page($size->name); ?></td>
                        <td><?= clean_page($size->width); ?></td>
                        <td><?= clean_page($size->height); ?></td>
                        <td>
                            <?php
                            if ($size->crop) {
                                ?>
                                <i class="fa fa-check"></i>
                                <?php
                            } else {
                                ?>
                                <i class="fa fa-remove"></i>
                                <?php
                            }
                            ?>
                        </td>
                        <td>
                            <?php
                            if ($size->forced) {
                                ?>
                                <i class="fa fa-check"></i>
                                <?php
                            } else {
                                ?>
                                <i class="fa fa-remove"></i>
                                <?php
                            }
                            ?>
                        </td>
                        <td class="center">
                            <?php
                            if (!in_array($size->id, $donotdelete)) {
                                $params = [
                                    'action' => 'delete',
                                    'delete_id' => clean_page($size->id),
                                ];
                                if (!empty($_REQUEST['page'])) {
                                    $params['page'] = $_REQUEST['page'];
                                }
                                ?>
                                <a href="paths.php?<?= http_build_query($params) ?>"
                                    class="alert error"
                                    title="Are you sure you want to delete this size?">
                                    <i class="fa fa-remove"></i>
                                </a>
                                <?php
                            }
                            ?>
                        </td>
                    </tr>
                    <?php
                }
                ?>
            </tbody>
        </table>
        <?php
    } else {
        ?>
        <p>There are currently no sizes added</p>
        <?php
    }
    ?>
</form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';