## Installation ##

```
git clone https://YOUR_BITBUCKET_NAME@bitbucket.org/mtcmedia/core-plugins-staticblocks.git ~/public_html/plugins/StaticBlocks

```

This plugin allows you to create content blocks on site that aren't linked to CMS Page.
Benefit of this is being able to call a block directly rather than accessing a page and retrieving its pagedata. 
There are 3 types of blocks supported:

* Tinymce text block - for text output
* Script block - for embedded scripts (banner scripts, iframes etc.)
* Image block - Block with an image that is cropped to relevant sizes

## Key Features ##

* No need to access page to retrieve pagedata.
* Easy to call via hook
* Images are automatically cropped to sizes defined in admin

```
#!php
{{ hooks_do_action('call_static_block', STATIC_BLOCK_ID) }}

```

* Ability to place placeholders and fill with values in template

```
Example text: 
All [[[BRAND]]] items come with a delivery cost of [[[DELIVERY_COST]]] for each item.

Hook for placeholder processing:
{{ hooks_do_action(
    'call_static_block',
    STATIC_BLOCK_ID,
    {
        'BRAND': brand_data.name,
        'DELIVERY_COST': brand_data.delivery_cost|currency_format()
    }
) }}
```

