<?php

namespace Mtc\Plugins\Wisebee\Classes\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\Modules\Members\Models\MemberNote;

/**
 * Accessors
 *
 * @property int $id
 * @property int $wisebee_id
 * @property int $member_note_id
 * @property string $updated_at
 * @property string $created_at
 *
 * @property MemberNote $note
 */

class WisebeeNote extends Model
{
    protected $table = 'wisebee_notes';

    protected $fillable = [
        'wisebee_id',
        'member_note_id',
    ];

    public function note(): BelongsTo
    {
        return $this->belongsTo(MemberNote::class, 'member_note_id');
    }
}