<?php

namespace MtcPharmacy\Bundles\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Mtc\Shop\Basket\Item as BasketItem;
use Mtc\Modules\Members\Classes\Auth;
use MtcPharmacy\Subscriptions\Classes\Subscription;


class Bundle extends Model
{
    protected $table = 'bundles';

    protected $fillable = [
        'name',
    ];


    public function items()
    {
        return $this->hasMany(BundleItem::class);
    }


    public function type()
    {
        return $this->belongsTo(BundleType::class);
    }


    public function get_display_name()
    {
        $bundle_name = $this->name ?: 'Bundle';

        return $bundle_name;
    }


    public function get_display_item_names()
    {
        $item_names = [];

        foreach ($this->items as $item) {
            $item_names[] = $item->getDisplayName();
        }

        return $item_names;
    }


    public function get_price()
    {
        $price = 0;

        foreach ($this->items as $item) {
            if ($item->shop_item_size) {
                $price += $item->shop_item_size->price;
            } else {
                $price += $item->shop_item->price;
            }
        }

        return $price;
    }


    public function get_payable_price()
    {
        $price = $this->get_price() * 2;

        return $price;
    }


    public function getBundleTypeItems()
    {
        $bundle_type_items = collect([]);

        $shop_items = [];

        foreach ($this->items as $bi) {
            $bundle_type_items->push($bi->bundle_type_item);
        }

        return $bundle_type_items;
    }


    public function addItems(Collection $bundle_type_items)
    {
        foreach ($bundle_type_items as $bti) {
            $bundle_item = new BundleItem();
            $bundle_item->bundle_type_item()->associate($bti);
            $this->items()->save($bundle_item);
        }
    }


    public function addToBasket(\Basket $basket)
    {
        foreach ($this->items as $bundle_item) {
            $bti = $bundle_item->bundle_type_item;
            $basket_item_id = $basket->Add_Item([
                'id' => $bti->shop_item->id,
                'quantity' => 1,
                'size' => $bti->shop_item_size->size ?? null,
                'size_id' => $bti->shop_item_size->id ?? null,
            ]);

            if ($basket_item_id) {
                $basket_item = BasketItem::find($basket_item_id);
                $basket_item->bundle_id = $this->id;
                $basket_item->has_requested_subscription = true;
                $basket_item->save();
            }
        }
    }


    public function authorise_access_by_current_user()
    {
        $can_access = false;

        $owned_bundle_ids = [];

        $basket = \Basket::getCurrent();
        if ($basket->eloquent()->items) {
            $owned_bundle_ids = array_merge(
                $owned_bundle_ids,
                $basket->eloquent()->items->pluck('bundle_id')->toArray()
            );
        }

        if ($customer = Auth::getLoggedInMember()) {
            $subscriptions = Subscription::query()
                ->where('member_id', $customer->id)
                ->get()
            ;

            foreach ($subscriptions as $sub) {
                $owned_bundle_ids = array_merge(
                    $owned_bundle_ids,
                    $sub->orders->first()->items->pluck('bundle_id')->toArray()
                );
            }
        }

        if (in_array($this->id, $owned_bundle_ids)) {
            $can_access = true;
        }

        if (! $can_access) {
            abort(403, 'You have no permissions to access this bundle.');
        }
    }
}
