<?php

namespace MtcPharmacy\Multisite;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;
use MtcPharmacy\Multisite\Classes\MultisiteBaseEntity;
use MtcPharmacy\Multisite\Classes\MultisiteConstants;
use MtcPharmacy\Multisite\Classes\MultisiteManager;
use Mtc\Shop\Item as MtcShopItem;


class MultisiteServiceProvider extends ServiceProvider
{

    public function boot() : void
    {
        $this->loadRoutesFrom(__DIR__ . '/routes/web.php');

        // Pharmacy platform uses custom twig template loaders.
        $view_paths = \Config::get('view.paths');
        $view_paths[] = __DIR__ . '/templates';
        \Config::set('view.paths', $view_paths);
    }


    public function register()
    {
        return false;
        Event::listen('AdminShopItemCreated', function(MtcShopItem $shop_item) {
            MultisiteBaseEntity::create([
                'concrete_entity_id' => $shop_item->id,
                'concrete_entity_type' => MultisiteConstants::ENTITY_TYPE_SHOP_ITEM,
                'mode' => MultisiteConstants::MODE_SINGLE_SITE,
            ]);
        });


        Event::listen('AdminBeforeBreadcrumbs', function(?object $concrete_entity, bool $allow_mode_switching = true) {
            if ($concrete_entity) {
                $multisite_manager = new MultisiteManager($concrete_entity);
                echo $multisite_manager->getToggleHtml($allow_mode_switching);
            }
        });
    }

}
