<?php

namespace MtcPharmacy\QualifyingAnswers\Classes;

use Mtc\Shop\Assessment\Form;
use Mtc\Shop\Item;
use Illuminate\Support\Arr;


class QualifyingAnswersHelper
{

    public static function renderDownloadTemplatesForm()
    {
        $download_templates_url = route('admin-qualifying-answers-download-templates', [], false);

        echo app('twig')->render('download_templates_form.twig', [
            'download_templates_url' => $download_templates_url,
        ]);
    }


    public static function getPossibleAnswersArray(string $input_string)
    {
        $possible_answers = [];

        if (trim($input_string)) {
            $possible_answers = explode(' | ', $input_string);
        }

        return $possible_answers;
    }


    public static function renderItemForm(Item $item)
    {
        $assessment_form = $item->findAssessmentForm();

        if (! $assessment_form) return;

        $questions = self::downloadTemplates($assessment_form);
        array_shift($questions);

        foreach ($questions as &$question) {
            $question['possible_answers_array'] = self::getPossibleAnswersArray($question['Question Possible Answers']);
        }

        QualifyingAnswer::ensureRelevantRowsExistForShopItem($item);

        $groups_config = QualifyingAnswersGroupsConfig::query()
            ->where('item_id', $item->id)
            ->first()
        ;

        $qualifying_answers = $groups_config->getAnswers();

        $answers = [];
        foreach ($qualifying_answers as $qualifying_answer) {
            $answers[$qualifying_answer->question_id] = $qualifying_answer->toArray();
        }
        
        $groups = $groups_config->groups;
        foreach ($groups as &$group) {
            $group->hex_rgb = $group->template->hex_rgb;
            $group->label = $group->template->label;
        }

        echo app('twig')->render('item_form.twig', [
            'item' => $item,
            'questions' => $questions,
            'answers' => $answers,
            'groups_config' => $groups_config,
            'groups' => $groups,
            'upsert_url' => route('admin-qualifying-answers-upsert', [], false),
        ]);
    }


    public static function getRelevantQuestions(Form $form)
    {
        $relevant_questions = collect([]);

        foreach ($form->questions as $question) {
            if (in_array(
                $question->question_type,
                [ 'yes', 'yes_no', 'variations', 'date', 'bmi' ]
            )) {
                $relevant_questions->push($question);
            }
        }

        return $relevant_questions;
    }


    public static function downloadTemplates(Form $form = null) : array
    {
        $rows = [];

        if ($form) {
            $forms = collect([ $form ]);
        } else {
            $forms = Form::query()->get();
        }

        foreach ($forms as $form) {

            $header = [
                'Form ID',
                'Form Name',
                'Question ID',
                'Question Type',
                'Question Is Multi',
                'Question Possible Answers',
                'Question',
            ];

            $items_in_order = [];
            foreach ($form->items as $item) {
                $header[] = "{$item->id} | {$item->name}";
                $items_in_order[] = $item->id;
            }

            $rows[] = array_combine($header, $header);

            $column_count = count($header);

            foreach ($form->questions as $question) {

                if (! in_array(
                    $question->question_type,
                    [ 'yes', 'yes_no', 'variations', 'date', 'bmi' ]
                )) {
                    continue;
                }


                $possible_answers = '';

                if ($question->variations) {
                    $possible_answers = implode(' | ', json_decode($question->variations, true));
                } elseif (in_array($question->question_type, [ 'yes', 'yes_no' ])) {
                    $possible_answers = 'yes | no';
                }

                $temp_row = [
                    $form->id,
                    $form->name,
                    $question->id,
                    $question->question_type,
                    $question->is_multiple,
                    $possible_answers,
                    $question->question_text,
                ];
                $rows[] = array_combine(
                    $header,
                    self::pad_with_answers($temp_row, $question->id, $items_in_order)
                );
            }

            if ($form->id != $forms->last()->id) {
                $rows[] = array_pad([], $column_count, '');
                $rows[] = array_pad([], $column_count, '');
                $rows[] = array_pad([], $column_count, '');
            }
        }

        return $rows;
    }


    private static function pad_with_answers(array $temp_row, $question_id, array $items_in_order)
    {
        //$qualifying_answers = QualifyingAnswer::query()
        //    ->where('question_id', $question_id)
        //    ->pluck('qualifying_answer', 'item_id')
        //;

        foreach ($items_in_order as $item_id) {
            $temp_row[] = ''; //Arr::get($qualifying_answers, $item_id);
        }

        return $temp_row;
    }

}
