<?php
$adminUser = \Mtc\Core\Admin\User::query()->find($adminuser->user['id']);

if ($order->address['billing']['country'] != 'GB' && $order->address['billing']['country'] != 'US' && $_SESSION['currency'] != 'USD') {
    $worldwide = true;
}
?>

<div class="table-style-1">
    <table width="100%" class="manage-items">
        <tr class="row_heading">
            <th style="text-align:left;" colspan="2">Name</th>
            <th>Quantity</th>
            <th>Next Refill</th>
            <th>Status</th>
            <th>Edit</th>
        </tr>
        <tbody class="tabular">
        <?php
        foreach ($order->getItems() as $order_item_id => $line) {
            $item = new Item();
            $item->Get_Item($line['item_id']);
            $approval_status = '';
            if ((int)$line['approved'] === 1) {
                $approval_status = 'approved';
            }
            if ((int)$line['approved'] === 2) {
                $approval_status = 'rejected';
            }
            ?>
            <tr>
                <td colspan="2">
                    <a href="<?= $item->url; ?>" target="_blank">
                        <?= clean_page($line['item_name']); ?>
                        <?php
                        if ($line['PLU']) {
                            ?>
                            <br/>(<?= clean_page($line['PLU']) ?>)
                            <?php
                        }
                        ?>
                    </a><?= $line['preorder'] ? ' - <span style="color:orange;">preordered</span>' : ''; ?>

                </td>
                <td>
                    <?= $line['size'] ?>
                </td>
                <td>
                    <?php
                    $line_reminder = \Mtc\Plugins\NHS\Classes\Reminder::query()->where('order_item_id', $line['id'])->first();
                    if ($line_reminder) {
                        echo $line_reminder->refill_date->format('d/m/Y');
                    }
                    ?>
                </td>
                <td>
                    <span id="orderItemStatus-<?= $order_item_id; ?>"
                          class="orderItemStatus <?= $approval_status; ?>"
                    >
                        <?= ucfirst($approval_status); ?>
                    </span>
                </td>
                <td>
                    <a href="manage.order.item.php?<?= http_build_query([
                        'order_id' => $line['order_id'],
                        'id' => $line['id'],
                    ]) ?>">
                        <i class="fa fa-pencil"></i>
                    </a>
                </td>
                <td>
                    <button type="button"
                            data-order_id="<?= $order->getId(); ?>"
                            data-order_item_id="<?= $order_item_id; ?>"
                            data-action="approve"
                            class="btn btn-green approveRejectOrderItem"
                            id="approveRejectOrderItem-<?= $order_item_id; ?>"
                    >
                        Approve
                    </button>
                    <button type="button"
                            data-order_id="<?= $order->getId(); ?>"
                            data-order_item_id="<?= $order_item_id; ?>"
                            data-action="reject"
                            class="btn btn-red approveRejectOrderItem"
                            id="approveRejectOrderItem-<?= $order_item_id; ?>"
                    >
                        Reject
                    </button>
                </td>
            </tr>
            <?php
        }
        ?>


        <?php

        //order_preview_popup used in manage.orders and manage.orders
        if ($order_preview_popup !== true) {
            ?>

            <tr>
                <td style="border-bottom:1px solid #ccc;" colspan="<?= $admin ? '9' : '8'; ?>">&nbsp;</td>
            </tr>

            <tr>
                <td colspan="<?= $admin ? '9' : '8'; ?>">&nbsp;</td>
            </tr>

            <?php
        }
        ?>

        <?php
        if ($show_totals !== false) {
            ?>
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <th colspan="<?= $admin ? '4' : '3'; ?>" style="text-align:right;">
                    Sub Total
                </th>
                <td align="right" style="text-align:right;">
                    &pound;
                    <?php
                    printf("%.2f", $order->getSubtotalCost());
                    ?>
                </td>
            </tr>

            <?php

            if (sizeof($order->discounts) > 0) {
                foreach ($order->discounts as $discount) {
                    ?>
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <th colspan="<?= $admin ? '4' : '3'; ?>" class="subfieldname" align="right"
                            style="text-align:right; padding-right: 10px;">
                            <?= clean_page($discount['discount_name']); ?>
                        </th>
                        <td align="right" style="text-align:right;">
                            <p>
                                -&pound;
                                <?php
                                printf("%.2f", $discount['discount_amount']);
                                ?>
                            </p>
                        </td>
                    </tr>
                    <?php
                }
            }
            ?>

            <?php
            if ($order->coupon_deduct > 0) {
                ?>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <th colspan="<?= $admin ? '4' : '3'; ?>" class="subfieldname" align="right"
                        style="text-align:right; padding-right: 10px;">Discount
                    </th>
                    <td align="right" style="text-align:right;"><p><?php printf("%.2f", $order->coupon_deduct); ?></p>
                    </td>
                </tr>
                <?php
            }

            if ($order->coupon_freedelivery) {
                ?>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <th colspan="<?= $admin ? '4' : '3'; ?>" class="subfieldname" align="right">Delivery</th>
                    <td align="right" style="text-align:right;">FREE</td>
                </tr>
                <?php
            } else {
                ?>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <th colspan="<?= $admin ? '5' : '4'; ?>" class="subfieldname" align="right"
                        style="text-align:right;">
                        Shipping: <?= clean_page($order->getDelivery()->name) ?>

                    </th>
                    <td align="right" style="text-align:right;">
                        <?php
                        if ($order->getDelivery()->cost > 0) {
                        ?>&pound;<?php printf("%.2f", $order->getDelivery()->cost); ?>
                        <?php //if($worldwide) echo '<span class="orange">($'.number_format( $order->cost_delivery_usd, 2).')</span>';?>
                        <?php
                        if (!empty($order->delivery_refund)) {
                            ?>
                            <span style="color:#ff0000;">-<?php
                                printf("%.2f", $order->delivery_refund);
                                $refund_total += $order->delivery_refund;
                                ?></span>
                            <?php
                        }
                        } else {
                            echo "FREE";
                        }
                        ?>
                    </td>
                </tr>
                <?php
            }
            ?>
            <?php
            if (BASKET_SHOW_VAT) {
                ?>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <th colspan="<?= $admin ? '4' : '3'; ?>" style="text-align:right;">VAT
                        (inclusive)<?php if (!VAT_ENABLED) { ?>at <?= (VAT_RATE) ?>%<?php } ?></th>
                    <td align="right" style="text-align:right;">
                        <?php
                        if (($vat_cost = $order->getVatCost()) > 0) {
                            printf('&pound;%s', number_format($vat_cost, 2));
                        } else {
                            echo 'No Vat';
                        }
                        ?>
                    </td>
                </tr>
                <?php
            }
            ?>
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <th colspan="<?= $admin ? '3' : '2'; ?>" class="subfieldname" align="right" style="text-align:right;">
                    Total Cost
                </th>
                <td align="right" style="text-align:right;">
                    &pound;<?php printf("%.2f", $order->getTotalCost()); ?>
                </td>
            </tr>
            <?php
            if ($refund_total > 0) {
                ?>
                <tr style="color:#ff0000;">
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <th colspan="<?= $admin ? '3' : '2'; ?>" class="subfieldname" align="right"
                        style="text-align:right;">Total Refunded
                    </th>
                    <td align="right" style="text-align:right;">
                        <?php printf("%.2f", $refund_total); ?>
                    </td>
                </tr>
                <tr style="color:#ff0000;">
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <th colspan="<?= $admin ? '3' : '2'; ?>" class="subfieldname" align="right"
                        style="text-align:right;">Total Paid
                    </th>
                    <td align="right" style="text-align:right;">
                        <?php printf("%.2f", $order->getTotalCost() - $refund_total); ?>
                    </td>
                </tr>
                <?php
            }
        }
        ?>
        </tbody>
    </table>
</div>

<script>
    $('.approveRejectOrderItem').on('click', function () {
        $.get('/shop/admin/ajax.php', {
            action: 'approve_reject_item',
            order_id: $(this).data('order_id'),
            order_item_id: $(this).data('order_item_id'),
            approve: $(this).data('action') === 'approve' ? '1' : '0',
            reject: $(this).data('action') === 'reject' ? '1' : '0'
        }).success(function (response) {
            response = $.parseJSON(response);
            if (response.success) {
                if (response.approve === 1) {
                    $('#orderItemStatus-' + response.order_item_id).html('Approved').removeClass('rejected').addClass('approved');
                } else if (response.approve === 2) {
                    $('#orderItemStatus-' + response.order_item_id).html('Rejected').removeClass('rejected').addClass('rejected');
                } else {
                    $('#orderItemStatus-' + response.order_item_id).html('').removeClass('approved').removeClass('rejected');
                }
            } else if (response.error !== '') {
                alert('Error: ' + response.error);
            }
        });
    });
</script>