<?php

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Admin\User;

/**
 * Created by PhpStorm.
 * User: matiss.bisofs
 * Date: 18/09/2017
 * Time: 17:43
 */
class ApprovalLog extends Model
{

    protected $table = 'approval_log';

    protected $fillable = [
        'user_id',
        'order_item_id',
        'status',
        'ip_address',
        'browser',
    ];

    public static function log(int $doctor_id, int $order_item_id, string $status)
    {
        parent::create([
            'user_id' => $doctor_id,
            'order_item_id' => $order_item_id,
            'status' => $status,
            'ip_address' => request()->ip(),
            'browser' => request()->userAgent(),
        ]);
    }

    public function doctor()
    {
        return $this->hasOne(\Mtc\Core\Admin\User::class, 'id', 'user_id');
    }

    public function admin()
    {
        return $this->belongsTo(\Mtc\Core\AdminUser::class, 'user_id');
    }

}
