<?php

Class ParcelForce implements CourierInterface
{

    /**
     * generateExport() Creates a csv of order information required for importing into parcel force.
     *
     * @param $orders Array of order ids
     */
    public function generateExport($orders)
    {
        header("Content-type: application/octet-stream");
        header("Content-Disposition: attachment; filename=\"parcel-" . time() . ".csv\"");


        $out = fopen('php://output', 'w');


        $header=array("FILLER",
                      "Business Name",
                      "Address1",
                      "Address 2",
                      "Address 3",
                      "Post Town",
                      "Postcode",
                      "Consignee Phone",
                      "Reference Number");



        fputcsv($out,$header);

	    $i=0;
        foreach($orders as $order_id)
        {
            $i++;

            $order = new Order($order_id);

            $row=array();

            $row[]=$i;
            $row[]=$order->address['shipping']['firstname'] . ' ' . $order->address['shipping']['lastname'];
            $row[]=$order->address['shipping']['address1'];
            $row[]=$order->address['shipping']['address2'];
            $row[]='';
            $row[]=$order->address['shipping']['city'];
            $row[]=$order->address['shipping']['postcode'];
            $row[]=$order->info['contact_no'];
            $row[]=$order_id;

            fputcsv($out,$row);
        }

        fclose($out);
    }

}