<?php
/**
 * Basket Info Object Eloquent model.
 * @version 13/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Basket;

use App\Casts\OptionalEncrypted;
use App\Src\Encryption;
use Illuminate\Database\Eloquent\Model;

/**
 * Basket Info Object Eloquent model.
 * Implements functionality for managing Shop Basket Customer Info
 *
 * @version 13/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Info extends Model
{
    // Use trait that defines relationship to basket
    use BelongsToBasket;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'basket_info';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'basket_id',
        'email',
        'phone_prefix',
        'contact_no',
        'message',
        'newsletter',
        'how_did_you_hear_about_us',
        'dob',
        'multisite__site_id',
        'assessment_ids'
    ];

    protected $casts = [
        'email' => OptionalEncrypted::class,
        'contact_no' => OptionalEncrypted::class,
        'dob' => OptionalEncrypted::class,
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
}
