<?php

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;

/**
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class Incompatibility extends Model
{
    protected $guarded = [
        'id',
    ];

    /**
     * Define the relationship to Categories
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function categories()
    {
        return $this->belongsToMany(Category::class, 'incompatible_categories', 'incompatibility_id', 'category_id');
    }

}
